/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 2-BIT BY 4-BIT PARALLEL BINARY MULTIPLEXERS
TRUTHTABLE     : 
                 
     --------------------------------------------------- 
      LATCH CONTROL   MULTIPLIER        OUTPUTS
            C         M2  M1  M0    Q4_  Q3  Q2  Q1  Q0 
     ---------------------------------------------------
            L         X   X   X     Q4_  Q3  Q2  Q1  Q0
            H         L   L   L     H    L   L   L   L
            H         L   L   H    ~B4   B4  B3  B2  B1 
            H         L   H   L    ~B4   B4  B3  B2  B1 
            H         L   H   H    ~B4   B3  B2  B1  B0
            H         H   L   L     B4  ~B3 ~B2 ~B1 ~B0
            H         H   L   H     B4  ~B4 ~B3 ~B2 ~B1
            H         H   H   L     B4  ~B4 ~B3 ~B2 ~B1
            H         H   H   H     H    L   L   L   L
     ---------------------------------------------------
                    
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a261 (b3, b4, c, m2, q4n, q3, q2, q1, q0, m0, m1, b0, b1, b2);
	parameter size =1;
	input
		b3,
		b4,
		c,
		m2,
		m0,
		m1,
		b0,
		b1,
		b2;
	output
		q4n,
		q3,
		q2,
		q1,
		q0;
    reg
        NOTIFY_REG;
    not
	M261N_inst_I1 (m261n_inst_wi1, b0);
    not
	M261N_inst_I2 (m261n_inst_wi2, m261n_inst_wi1);
    not
	M261N_inst_I3 (m261n_inst_wi3, b1);
    not
	M261N_inst_I4 (m261n_inst_wi4, m261n_inst_wi3);
    not
	M261N_inst_I5 (m261n_inst_wi5, b2);
    not
	M261N_inst_I6 (m261n_inst_wi6, m261n_inst_wi5);
    not
	M261N_inst_I7 (m261n_inst_wi7, b3);
    not
	M261N_inst_I8 (m261n_inst_wi8, m261n_inst_wi7);
    not
	M261N_inst_I9 (m261n_inst_wi9, b4);
    not
	M261N_inst_I10 (m261n_inst_wi10, m261n_inst_wi9);
    not
	M261N_inst_I11 (m261n_inst_wi11, c);
    not
	M261N_inst_I12 (m261n_inst_wi12, m261n_inst_q4bint);
    and
	M261N_inst_A1 (m261n_inst_wa1, m261n_inst_wi2, m261n_inst_wa26, m261n_inst_wn3);
    and
	M261N_inst_A2 (m261n_inst_wa2, m261n_inst_wi1, m261n_inst_wn1, m261n_inst_wn4);
    and
	M261N_inst_A3 (m261n_inst_wa3, m261n_inst_wi4, m261n_inst_wn2, m261n_inst_wn3);
    and
	M261N_inst_A4 (m261n_inst_wa4, m261n_inst_wi3, m261n_inst_wn2, m261n_inst_wn4);
    and
	M261N_inst_A5 (m261n_inst_wa5, m261n_inst_wi11, m261n_inst_q0int);
    and
	M261N_inst_A6 (m261n_inst_wa6, m261n_inst_wi4, m261n_inst_wa26, m261n_inst_wn3);
    and
	M261N_inst_A7 (m261n_inst_wa7, m261n_inst_wi3, m261n_inst_wn1, m261n_inst_wn4);
    and
	M261N_inst_A8 (m261n_inst_wa8, m261n_inst_wi6, m261n_inst_wn2, m261n_inst_wn3);
    and
	M261N_inst_A9 (m261n_inst_wa9, m261n_inst_wi5, m261n_inst_wn2, m261n_inst_wn4);
    and
	M261N_inst_A10 (m261n_inst_wa10, m261n_inst_wi11, m261n_inst_q1int);
    and
	M261N_inst_A11 (m261n_inst_wa11, m261n_inst_wi6, m261n_inst_wa26, m261n_inst_wn3);
    and
	M261N_inst_A12 (m261n_inst_wa12, m261n_inst_wi5, m261n_inst_wn1, m261n_inst_wn4);
    and
	M261N_inst_A13 (m261n_inst_wa13, m261n_inst_wi8, m261n_inst_wn2, m261n_inst_wn3);
    and
	M261N_inst_A14 (m261n_inst_wa14, m261n_inst_wi7, m261n_inst_wn2, m261n_inst_wn4);
    and
	M261N_inst_A15 (m261n_inst_wa15, m261n_inst_wi11, m261n_inst_q2int);
    and
	M261N_inst_A16 (m261n_inst_wa16, m261n_inst_wi8, m261n_inst_wn3, m261n_inst_wa26);
    and
	M261N_inst_A17 (m261n_inst_wa17, m261n_inst_wi7, m261n_inst_wn1, m261n_inst_wn4);
    and
	M261N_inst_A18 (m261n_inst_wa18, m261n_inst_wi10, m261n_inst_wn2, m261n_inst_wn3);
    and
	M261N_inst_A19 (m261n_inst_wa19, m261n_inst_wn2, m261n_inst_wi9, m261n_inst_wn4);
    and
	M261N_inst_A20 (m261n_inst_wa20, m261n_inst_wi11, m261n_inst_q3int);
    and
	M261N_inst_A21 (m261n_inst_wa21, m261n_inst_wi10, m261n_inst_wa26, m261n_inst_wn3);
    and
	M261N_inst_A22 (m261n_inst_wa22, m261n_inst_wi9, m261n_inst_wn1, m261n_inst_wn4);
    and
	M261N_inst_A23 (m261n_inst_wa23, m261n_inst_wi10, m261n_inst_wn2, m261n_inst_wn3);
    and
	M261N_inst_A24 (m261n_inst_wa24, m261n_inst_wn2, m261n_inst_wi9, m261n_inst_wn4);
    and
	M261N_inst_A25 (m261n_inst_wa25, m261n_inst_wi11, m261n_inst_wi12);
    and
	M261N_inst_A26 (m261n_inst_wa26, m0, m1);
    nor
	M261N_inst_N1 (m261n_inst_wn1, m0, m1);
    nor
	M261N_inst_N2 (m261n_inst_wn2, m261n_inst_wa26, m261n_inst_wn1);
    nor
	M261N_inst_N3 (m261n_inst_wn3, m2, m261n_inst_wi11);
    nor
	M261N_inst_N4 (m261n_inst_wn4, m261n_inst_wn3, m261n_inst_wi11);
    nor
	M261N_inst_N5 (m261n_inst_q4bint, m261n_inst_wa21, m261n_inst_wa22, m261n_inst_wa23, m261n_inst_wa24, m261n_inst_wa25);
    U_NOTI
	M261N_inst_U1 (m261n_inst_q0int1, m261n_inst_q0int, NOTIFY_REG);
    U_NOTI
	M261N_inst_U2 (m261n_inst_q1int1, m261n_inst_q1int, NOTIFY_REG);
    U_NOTI
	M261N_inst_U3 (m261n_inst_q2int1, m261n_inst_q2int, NOTIFY_REG);
    U_NOTI
	M261N_inst_U4 (m261n_inst_q3int1, m261n_inst_q3int, NOTIFY_REG);
    U_NOTI
	M261N_inst_U5 (m261n_inst_q4bint1, m261n_inst_q4bint, NOTIFY_REG);
    buf  
	  (q0, m261n_inst_q0int1);
    buf  
	  (q1, m261n_inst_q1int1);
    buf  
	  (q2, m261n_inst_q2int1);
    buf  
	  (q3, m261n_inst_q3int1);
    buf  
	  (q4n, m261n_inst_q4bint1);
    or
	M261N_inst_O1 (m261n_inst_q0int, m261n_inst_wa1, m261n_inst_wa2, m261n_inst_wa3, m261n_inst_wa4, m261n_inst_wa5);
    or
	M261N_inst_O2 (m261n_inst_q1int, m261n_inst_wa6, m261n_inst_wa7, m261n_inst_wa8, m261n_inst_wa9, m261n_inst_wa10);
    or
	M261N_inst_O3 (m261n_inst_q2int, m261n_inst_wa11, m261n_inst_wa12, m261n_inst_wa13, m261n_inst_wa14, m261n_inst_wa15);
    or
	M261N_inst_O4 (m261n_inst_q3int, m261n_inst_wa16, m261n_inst_wa17, m261n_inst_wa18, m261n_inst_wa19, m261n_inst_wa20);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
